%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
%Introduced: Palamedes version 1.0.0 (NP)
%Modified: Palamedes version 1.5.0 (see History.m)

function [PosteriorTplus1givenSuccess PosteriorTplus1givenFailure] = PAL_AMPM_PosteriorTplus1(pdf, PFLookUpTable)

pdf5D = repmat(pdf, [1 1 1 1 size(PFLookUpTable,5)]);

Denominator = squeeze(sum(sum(sum(sum(pdf5D.*PFLookUpTable,1),2),3),4));
Denominator = repmat(Denominator, [1 size(pdf5D,1) size(pdf5D,2) size(pdf5D,3) size(pdf5D,4)]);
Denominator = permute(Denominator, [2 3 4 5 1]);

PosteriorTplus1givenSuccess = (pdf5D.*PFLookUpTable)./Denominator;

Denominator = squeeze(sum(sum(sum(sum(pdf5D.*(1-PFLookUpTable),1),2),3),4));
Denominator = repmat(Denominator, [1 size(pdf5D,1) size(pdf5D,2) size(pdf5D,3) size(pdf5D,4)]);
Denominator = permute(Denominator, [2 3 4 5 1]);

PosteriorTplus1givenFailure = (pdf5D.*(1-PFLookUpTable))./Denominator;