%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
%Introduced: Palamedes version 1.0.0 (NP)
%Modified: Palamedes version 1.2.0 (see History.m)

function [StimLevelsG NumPosG OutOfNumG] = PAL_PFML_GroupTrialsbyX(StimLevels, NumPos, OutOfNum)

for row = 1:size(StimLevels,1)

    StimLevelsRow = squeeze(StimLevels(row,:));
    NumPosRow = squeeze(NumPos(row,:));
    OutOfNumRow = squeeze(OutOfNum(row,:));
    
    StimLevelsRow = StimLevelsRow(OutOfNumRow ~= 0);
    NumPosRow = NumPosRow(OutOfNumRow ~= 0);
    OutOfNumRow = OutOfNumRow(OutOfNumRow ~= 0);
    NumPosGRow = [];
    OutOfNumGRow = [];
    xGRow = [];
    
    NumLevels = 1;

    while length(StimLevelsRow) ~= 0

        x = StimLevelsRow(1)*ones(size(StimLevelsRow));
        xGRow(NumLevels) = StimLevelsRow(1);
        match = (StimLevelsRow == x);
        OutOfNumGRow(NumLevels) = sum(OutOfNumRow(match));
        NumPosGRow(NumLevels) = sum(NumPosRow(match));
        OutOfNumRow = OutOfNumRow(match == 0);
        NumPosRow = NumPosRow(match == 0);
        StimLevelsRow = StimLevelsRow(match == 0);
        NumLevels = NumLevels+1;

    end

    [xG I] = sortrows(xGRow');
    NumPosG(row,1:length(NumPosGRow)) = NumPosGRow(I);
    OutOfNumG(row,1:length(OutOfNumGRow)) = OutOfNumGRow(I);
    StimLevelsG(row,1:length(xG)) = xG';

end