%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
% Introduced: Palamedes version 1.0.0 (NP)
% Modified: Palamedes version 1.3.0, 1.4.0 (see History.m)

function NumPos = PAL_PF_SimulateObserverParametric(paramsValues, StimLevels, OutOfNum, PF, varargin)

lapseFit = 'nAPLE';
gammaEQlambda = logical(false);

if ~isempty(varargin)
    NumOpts = length(varargin);
    for n = 1:2:NumOpts
        valid = 0;
        if strncmpi(varargin{n}, 'lapseFit',6)
            lapseFit = varargin{n+1};
            valid = 1;
        end
        if strncmpi(varargin{n}, 'gammaEQlambda',6)
            gammaEQlambda = logical(varargin{n+1});
            valid = 1;
        end                                
        if valid == 0
            message = ['Warning: ' varargin{n} ' is not a valid option. Ignored.'];
            disp(message);
        end
    end            
end

if gammaEQlambda
   paramsValues(3) = paramsValues(4);
end

pcorrect = PF(paramsValues, StimLevels);

if strncmpi(lapseFit,'jap',3) || strncmpi(lapseFit,'iap',3)

    pcorrect(find(StimLevels == max(StimLevels(OutOfNum>0)))) = 1-paramsValues(4);
    if gammaEQlambda
        pcorrect(find(StimLevels == min(StimLevels(OutOfNum>0)))) = paramsValues(4);        
    end
end
for Level = 1:length(StimLevels)
    Pos = rand(OutOfNum(Level),1);
    Pos(Pos < pcorrect(Level)) = 1;
    Pos(Pos ~= 1) = 0;
    NumPos(Level) = sum(Pos);
end