%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
% Introduced: Palamedes version 1.1.1 (NP)
% Modified: Palamedes version 1.2.0 (see History.m)

function [maxim Indices] = PAL_findMax(array)

singletonDim = uint16(size(array) == 1);
array = squeeze(array);    

if ndims(array) == 2           
    if isvector(array)        
        [maxim IndicesSqueezed] = max(array);
    else
        [array I] = max(array);
        [maxim I2] = max(array);
        IndicesSqueezed = [I(I2) I2];
    end
end
if ndims(array) == 3
    [array I] = max(array);
    [array I2] = max(array);
    [maxim I3] = max(array);
    IndicesSqueezed = [I(1,I2(I3),I3) I2(I3) I3];
end
if ndims(array) == 4        
    [array I] = max(array);        
    [array I2] = max(array);    
    [array I3] = max(array);   
    [maxim I4] = max(array);        
    IndicesSqueezed = [I(1,I2(1,1,I3(I4),I4),I3(I4),I4) I2(1,1,I3(I4),I4) I3(I4) I4];
end

singletonDim(singletonDim == 0) = IndicesSqueezed;
Indices = singletonDim;

