%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
%Introduced: Palamedes version 1.0.0 (NP)

function [alpha beta gamma lambda] = PAL_unpackParamsPF(params)

gamma = 0;
lambda = 0;

if isstruct(params)
    alpha = params.alpha;
    beta = params.beta;
    if isfield(params,'gamma')
        gamma = params.gamma;
        if isfield(params,'lambda')
            lambda = params.lambda;
        end
    end
else
    alpha = params(1);
    beta = params(2);
    if length(params) > 2
        gamma = params(3);
        if length(params) > 3
            lambda = params(4);
        end
    end
end