%codeSnippet1.m for www.palamedestoolbox.org/understandingfitting.html
%This code serves to demonstrate issues discussed on:
%www.palamedestoolbox.org/understandingfitting.html
%
%August, 2014 (NP). Updated: December, 2018 (NP)

clear all;

if ~exist('PAL_info','file')
    disp('This code snippet requires the Palamedes toolbox.');
    disp('Visit www.palamedestoolbox.org');
    return;
end

StimLevels = -.4:.1:.4;
NumPos = [6 6 7 9 10 7 9 10 10];
OutOfNum = [10 10 10 10 10 10 10 10 10];

%The following use of 'searchGrid' is not advised: it defines a single
%point only. See: www.palamedestoolbox.org/understandingfitting.html for 
%information on how to use searchGrid properly.

searchGrid.alpha = -.18;
searchGrid.beta = 10.^-.18;
searchGrid.gamma = 0.5;
searchGrid.lambda = 0;

PF = @PAL_Gumbel;
paramsFree = [1 1 0 0];

[paramValues LL exitflag output] = PAL_PFML_Fit(StimLevels,NumPos,OutOfNum,searchGrid,paramsFree,PF)

plot(-1:.01:1,PF(paramValues,-1:.01:1));
hold on
plot(StimLevels,NumPos./OutOfNum,'ko','markerfacecolor','k','markersize',12)