%codeSnippet3.m for www.palamedestoolbox.org/understandingfitting.html
%This code serves to demonstrate issues discussed on:
%www.palamedestoolbox.org/understandingfitting.html
%
%August, 2014 (NP). Updated: December, 2018 (NP)

clear all;

if ~exist('PAL_info','file')
    disp('This snippet requires the Palamedes toolbox.');
    disp('Visit www.palamedestoolbox.org');
    return;
end

StimLevels = -.4:.1:.4;
NumPos = [6 6 7 9 10 7 9 10 10];
OutOfNum = [10 10 10 10 10 10 10 10 10];

searchGrid.alpha = -.4:.005:.4;
searchGrid.beta = 10.^[-1:.025:2];
searchGrid.gamma = 0.5;         
searchGrid.lambda = 0.06;   %restrict brute force to lapse rate = 0.06 ...

PF = @PAL_Gumbel;
paramsFree = [1 1 0 1];     %... but free lapse rate in Nelder-Mead (Do not
lapseLimits = [0 1];        %try this at home. This is a demonstration of
                            %how NOT to do it).

[paramValues LL exitflag output] = PAL_PFML_Fit(StimLevels,NumPos,OutOfNum,searchGrid,paramsFree,PF,'lapseLimits',lapseLimits)

plot(-1:.01:1,PF(paramValues,-1:.01:1));
hold on
plot(StimLevels,NumPos./OutOfNum,'ko','markerfacecolor','k','markersize',12)