%codeSnippet4.m for www.palamedestoolbox.org/understandingfitting.html
%This code serves to demonstrate issues discussed on:
%www.palamedestoolbox.org/understandingfitting.html
%
%August, 2014 (NP). Updated: December, 2018 (NP)

clear all;

if ~exist('PAL_info','file')
    disp('This snippet requires the Palamedes toolbox.');
    disp('Visit www.palamedestoolbox.org');
    return;
end

StimLevels = -.4:.2:.4;
NumPos = [10 9 6 10 8];
OutOfNum = [10 10 10 10 10];

searchGrid.alpha = -.4:.01:.4;
searchGrid.beta = 10.^[-1:.05:2];
searchGrid.gamma = 0.5;         
searchGrid.lambda = 0.03;

PF = @PAL_Gumbel;
paramsFree = [1 1 0 0];

%Next comman demonstrates default behavior in Palamedes version 1.9.0 and lower
%Search will fail: No maximum to be found. Solution at exit forms a
%near-straight, near-horizontal line at 0.86 (overall proportion correct)
%within stimulus range. This solution is asymptotically optimal given
%constraints.
[paramValues LL exitflag output] = PAL_PFML_Fit(StimLevels,NumPos,OutOfNum,searchGrid,paramsFree,PF,'checkLimit',false)

plot(-1:.01:1,PF(paramValues,-1:.01:1));
hold on
plot(StimLevels,NumPos./OutOfNum,'ko','markerfacecolor','k','markersize',12)

%Default behavior in Palamedes version 1.9.1 and higher
%Palamedes checks whether solution found by Nelder-Mead is at a true maximum
%or whether no true maximum exists. Here it finds that Nelder-Mead is not a
%true maximum, but that it instead tries to get close to the constant
%function at 0.86 (average proportion correct) which fits better than any
%sigmoid with finite-valued parameters.
[paramsValuesOut, LL, scenario, output] = PAL_PFML_Fit(StimLevels,NumPos,OutOfNum,searchGrid,paramsFree,PF)