%codeSnippet5.m for www.palamedestoolbox.org/understandingfitting.html
%This code serves to demonstrate issues discussed on:
%www.palamedestoolbox.org/understandingfitting.html
%
%August, 2014 (NP). Updated: December, 2018 (NP)

clear all;

if ~exist('PAL_info','file')
    disp('This snippet requires the Palamedes toolbox.');
    disp('Visit www.palamedestoolbox.org');
    return;
end

StimLevels = -.4:.2:.4;
NumPos = [6 8 8 10 9];
OutOfNum = [10 10 10 10 10];

searchGrid.alpha = -.4:.01:.4;
searchGrid.beta = 10.^[-1:.05:2];
searchGrid.gamma = 0.5;         
searchGrid.lambda = 0.03;

PF = @PAL_Gumbel;
paramsFree = [1 1 0 0];

%Fit succeeds ...
[paramValues LL exitflag output] = PAL_PFML_Fit(StimLevels,NumPos,OutOfNum,searchGrid,paramsFree,PF)

%But standard errors cannot be determined by bootstrap because for some of 
%bootstrap simulations no maximum in the likelihood function exists 
[SD , paramsSim, LLSim, scenario] = PAL_PFML_BootstrapParametric(StimLevels,OutOfNum, paramValues, paramsFree, 400, PF, 'searchGrid',searchGrid);

%Determining Goodness-of-fit is still okay because, even though some 
%bootstrap simulations fail, log-likelihood values for asymptotic fits
%are finite-valued and meaningful.
[Dev, pDev] = PAL_PFML_GoodnessOfFit(StimLevels,NumPos,OutOfNum, paramValues, paramsFree, 400, PF, 'searchGrid',searchGrid);