%codeSnippet6.m for www.palamedestoolbox.org/understandingfitting.html
%This code serves to demonstrate issues discussed on:
%www.palamedestoolbox.org/understandingfitting.html
%
%August, 2014 (NP). Updated: December, 2018 (NP)

clear all;

if ~exist('PAL_info','file')
    disp('This snippet requires the Palamedes toolbox.');
    disp('Visit www.palamedestoolbox.org');
    return;
end

StimLevels = -.4:.2:.4;
NumPos = [6 8 8 10 9];
OutOfNum = [10 10 10 10 10];

searchGrid.alpha = -.4:.01:.4;
searchGrid.beta = 1.3;
searchGrid.gamma = 0.5;         
searchGrid.lambda = 0.03;

PF = @PAL_Gumbel;
paramsFree = [1 0 0 0]; %Use a fixed slope, estimate threshold only
B = 400;                %number of simulations for bootstrap and goodness-of-fit

%Fit succeeds
[paramValues, LL, exitflag, output] = PAL_PFML_Fit(StimLevels,NumPos,OutOfNum,searchGrid,paramsFree,PF)

%Non-parametric bootstrap succeeds (best to avoid parametric bootstrap if you use fixed slope)
SD = PAL_PFML_BootstrapNonParametric(StimLevels,NumPos,OutOfNum,[],paramsFree,B,PF,'searchGrid',searchGrid)

%Goodness-of-fit succeeds
[Dev pDev] = PAL_PFML_GoodnessOfFit(StimLevels,NumPos,OutOfNum,paramValues,paramsFree,B,PF,'searchGrid',searchGrid)