%codeSnippet7.m for www.palamedestoolbox.org/understandingfitting.html
%This code serves to demonstrate issues discussed on:
%www.palamedestoolbox.org/understandingfitting.html
%
%August, 2014 (NP). Updated: December, 2018 (NP)

clear all;

if ~exist('PAL_info','file')
    disp('This snippet requires the Palamedes toolbox.');
    disp('Visit www.palamedestoolbox.org');
    return;
end

options = PAL_minimize('options');

%Case of field names must match exactly. E.g., options.tolx = 1 e-12 will 
%be ignored (no warning will be issued). Options structure must be passed
%to PAL_PFML_Fit (see call to PAL_PFML_Fit below) or will go ignored.
options.TolX = 1e-12;   %increase desired precision (by lowering tolerance)
options.TolFun = 1e-12;
options.MaxIter = 2000;
options.MaxFunEvals = 2000;
options.Display = 'iter';   %Display progress of Nelder-mead iteration-by-
                            %iteration
StimLevels = -.4:.1:.4;
NumPos = [6 6 7 9 10 7 9 10 10];
OutOfNum = [10 10 10 10 10 10 10 10 10];

searchGrid.alpha = -.4:.005:.4;
searchGrid.beta = 10.^[-1:.025:2];
searchGrid.gamma = 0.5;         
searchGrid.lambda = 0:.01:.15;

PF = @PAL_Gumbel;
paramsFree = [1 1 0 0];
lapseLimits = [0 1];

[paramValues LL exitflag output] = PAL_PFML_Fit(StimLevels,NumPos,OutOfNum,searchGrid,paramsFree,PF,'searchOptions',options)